//******************************************
// file			: ADC_Function.h
// version		: V1.0
// brief		: ADC header file
// note			:
//******************************************   
// #define W  H'0000' 
// #define F  H'0001'
// 

/***************************************
 * 
 * function :void adc_config_set(unsigned char,unsigned char,unsigned char,unsigned char)
 * 
 * *************************************/

/******************
 * 1st Argument
 * ****************/
#define		ADC_Single		0x1
#define		ADC_Repeat		0x3
/******************
 * 2nd Argument
 * ****************/
#define		AIN_EN			0x1
#define		AIN_DIS			0x0
/******************
 * 3rd Argument
 * ****************/
#define		AIN0			0x0     
#define		AIN1			0x1		
#define		AIN2			0x2
#define		AIN3			0x3
#define		AIN4			0x4
#define		AIN5			0x5
#define		AIN6			0x6
#define		AIN7			0x7
#define 	AIN8			0x8
#define     VDD4_1			0x9
#define     AIN_GND      	0xc
/******************
 * 4th Argument
 * ****************/
#define		Conv32CLK		0x0
#define		Conv64CLK		0x1
#define		Conv128CLK		0x2
#define		Conv256CLK		0x3
#define		Conv512CLK		0x4
#define		Conv1024CLK		0x5 
/******************
 * 5th Argument
 * ****************/
#define		Vref2			0x0
#define		Vref3			0x1
#define		Vref4			0x2
#define		VDDVref			0x3
#define		EXTVref			0x4


void adc_config_set(unsigned char,unsigned char,unsigned char,unsigned char,unsigned char);


void adc_start(void);

void adc_stop(void);

unsigned int adc_result_read(void);

#define ADC_EndFlag ADCCR2.bit.b7
#define ADC_BusyFlag ADCCR2.bit.b6